// Colores principales
const colors = {
  primary: {
    50: '#f0f9ff',
    100: '#e0f2fe',
    200: '#bae6fd',
    300: '#7dd3fc',
    400: '#38bdf8',
    500: '#0ea5e9',
    600: '#0284c7',
    700: '#0369a1',
    800: '#075985',
    900: '#0c4a6e',
  },
  secondary: {
    50: '#f8fafc',
    100: '#f1f5f9',
    200: '#e2e8f0',
    300: '#cbd5e1',
    400: '#94a3b8',
    500: '#64748b',
    600: '#475569',
    700: '#334155',
    800: '#1e293b',
    900: '#0f172a',
  },
  accent: {
    50: '#ecfdf5',
    100: '#d1fae5',
    200: '#a7f3d0',
    300: '#6ee7b7',
    400: '#34d399',
    500: '#10b981',
    600: '#059669',
    700: '#047857',
    800: '#065f46',
    900: '#064e3b',
  }
};

// Espaciado y tamaños
const spacing = {
  container: {
    sm: '640px',
    md: '768px',
    lg: '1024px',
    xl: '1280px',
  },
  padding: {
    page: '1.5rem',
    section: '4rem',
  },
  borderRadius: {
    sm: '0.375rem',
    md: '0.5rem',
    lg: '1rem',
    full: '9999px',
  },
};

// Tipografía
const typography = {
  fontFamily: {
    sans: ['Inter', 'system-ui', 'sans-serif'],
    serif: ['Merriweather', 'Georgia', 'serif'],
  },
  fontSize: {
    xs: '0.75rem',
    sm: '0.875rem',
    base: '1rem',
    lg: '1.125rem',
    xl: '1.25rem',
    '2xl': '1.5rem',
    '3xl': '1.875rem',
    '4xl': '2.25rem',
    '5xl': '3rem',
  },
};

// Efectos
const effects = {
  boxShadow: {
    sm: '0 1px 2px 0 rgba(0, 0, 0, 0.05)',
    md: '0 4px 6px -1px rgba(0, 0, 0, 0.1)',
    lg: '0 10px 15px -3px rgba(0, 0, 0, 0.1)',
  },
  transition: {
    fast: '150ms',
    normal: '300ms',
    slow: '500ms',
  },
};

export const theme = {
  colors,
  spacing,
  typography,
  effects,
};

// Clases comunes reutilizables
export const commonStyles = {
  // Contenedores
  pageContainer: 'max-w-7xl mx-auto px-4 sm:px-6 lg:px-8',
  sectionPadding: 'py-12 md:py-16 lg:py-20',
  
  // Botones
  buttonPrimary: 'px-5 py-2 rounded-full bg-blue-600 text-white font-semibold shadow hover:bg-blue-700 transition-colors duration-300',
  buttonSecondary: 'px-5 py-2 rounded-full border border-blue-600 text-blue-600 font-semibold hover:bg-blue-50 transition-colors duration-300',
  
  // Tarjetas
  card: 'bg-white rounded-lg shadow-md overflow-hidden',
  cardHover: 'hover:shadow-lg transition-shadow duration-300',
  
  // Fondos con blur
  glassEffect: 'bg-white/30 backdrop-blur-sm',
  
  // Textos
  heading1: 'text-4xl md:text-5xl lg:text-6xl font-bold',
  heading2: 'text-3xl md:text-4xl font-bold',
  heading3: 'text-2xl md:text-3xl font-bold',
  paragraph: 'text-gray-600 leading-relaxed',
  
  // Inputs
  input: 'w-full px-4 py-2 rounded-md border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition-colors duration-200',
  
  // Efectos de hover
  hoverScale: 'hover:scale-105 transition-transform duration-300',
  hoverBright: 'hover:brightness-110 transition-all duration-300',
}; 