/** @type {import('next').NextConfig} */
const nextConfig = {
  reactStrictMode: true,
  images: {
    formats: ["image/avif", "image/webp"],
    deviceSizes: [640, 750, 828, 1080, 1200, 1920, 2048],
    imageSizes: [16, 32, 48, 64, 96, 128, 256],
    minimumCacheTTL: 60 * 60 * 24 * 30, // 30 días
  },
  // Optimize fonts
  optimizeFonts: true,
  // Enable compression
  compress: true,
  // Reduce JavaScript bundle size
  swcMinify: true,
  // Trailing slash consistency
  trailingSlash: false,
  // Add HTTP response headers for better caching
  async redirects() {
    return [
      // Redirect www to non-www
      {
        source: "/:path*",
        has: [
          {
            type: "host",
            value: "www.elencantodebenasque.com",
          },
        ],
        destination: "https://elencantodebenasque.com/:path*",
        permanent: true,
      },
    ];
  },
  async headers() {
    return [
      {
        source: "/:all*(svg|jpg|png|webp|avif)",
        headers: [
          {
            key: "Cache-Control",
            value: "public, max-age=31536000, immutable",
          },
        ],
      },
      {
        source: "/favicon.ico",
        headers: [
          {
            key: "Cache-Control",
            value: "no-cache",
          },
          {
            key: "Content-Type",
            value: "image/x-icon",
          },
        ],
      },
      {
        source: "/favicon-:size*",
        headers: [
          {
            key: "Cache-Control",
            value: "no-cache",
          },
        ],
      },
      {
        source: "/_next/image/:all*",
        headers: [
          {
            key: "Cache-Control",
            value: "public, max-age=31536000, immutable",
          },
        ],
      },
      {
        source: "/fonts/:all*",
        headers: [
          {
            key: "Cache-Control",
            value: "public, max-age=31536000, immutable",
          },
        ],
      },
      {
        source: "/_next/static/:all*",
        headers: [
          {
            key: "Cache-Control",
            value: "public, max-age=31536000, immutable",
          },
        ],
      },
    ];
  },
};

// Eliminar withBundleAnalyzer para producción
typeof process !== "undefined" && process.env.ANALYZE === "true"
  ? (module.exports = require("@next/bundle-analyzer")({ enabled: true })(
      nextConfig,
    ))
  : (module.exports = nextConfig);
