const title =
  "Apartamento El Encanto de Benasque | Alojamiento turístico renovado a 5 min de Cerler";
const description =
  "Descubre nuestro apartamento recién renovado en Benasque. Alojamiento turístico acogedor en el corazón del Pirineo Aragonés, a 5 minutos de la estación de esquí Cerler. Precios especiales para verano 2025.";
const keywords = [
  "apartamento benasque",
  "apartamento renovado benasque",
  "alojamiento benasque",
  "alojamiento económico benasque",
  "alojamiento cerler",
  "apartamento pirineo",
  "apartamento cerler",
  "alquiler apartamento benasque",
  "alojamiento turístico benasque",
  "apartamento pirineo aragonés",
  "alojamiento cerca de cerler",
  "apartamento vacacional benasque",
  "alquiler apartamento benasque",
  "alojamiento valle de benasque",
  "apartamentos turísticos benasque",
  "alquiler vacacional cerler",
  "donde alojarse en benasque",
  "apartamento esquí cerler",
  "apartamento reformado benasque",
  "ofertas alojamiento benasque 2026",
];

const images = [
  {
    url: "https://elencantodebenasque.com/media/imagen-portada.webp",
    width: 1200,
    height: 630,
    alt: "El Encanto de Benasque - Apartamento renovado con vistas a la montaña",
    type: "image/webp",
  },
  {
    url: "https://elencantodebenasque.com/media/salon.webp",
    width: 1200,
    height: 630,
    alt: "Salón renovado con vistas al Pirineo",
    type: "image/webp",
  },
];

export default {
  title,
  description,
  canonical: "https://elencantodebenasque.com",
  languageAlternates: [
    {
      hrefLang: "es",
      href: "https://elencantodebenasque.com",
    },
    {
      hrefLang: "x-default",
      href: "https://elencantodebenasque.com",
    },
  ],
  openGraph: {
    type: "website",
    locale: "es_ES",
    url: "https://elencantodebenasque.com",
    title,
    description,
    images,
    site_name: "El Encanto de Benasque",
    priceRange: "80€ - 200€",
  },
  twitter: {
    handle: "@encantobenasque",
    site: "@encantobenasque",
    cardType: "summary_large_image",
  },
  additionalLinkTags: [
    {
      rel: "icon",
      href: "/favicon.ico",
    },
    {
      rel: "apple-touch-icon",
      href: "/apple-touch-icon.png",
      sizes: "180x180",
    },
    {
      rel: "manifest",
      href: "/site.webmanifest",
    },
  ],
  additionalJsonLd: [
    {
      "@context": "https://schema.org",
      "@type": "LodgingBusiness",
      "@id": "https://elencantodebenasque.com/#el-encanto-de-benasque",
      name: "El Encanto de Benasque",
      description: description,
      url: "https://elencantodebenasque.com",
      sameAs: [
        "https://www.booking.com/hotel/es/b29-el-encanto-de-benasque.es.html",
        "https://www.villmor.com/inmueble-de-alquiler-en-detalle/alquiler-apartamento-el-encanto-de-benasque-benasque-25859/",
      ],
      telephone: "974551733",
      image: images[0].url,
      address: {
        "@type": "PostalAddress",
        addressLocality: "Benasque",
        addressRegion: "Huesca",
        postalCode: "22440",
        addressCountry: "ES",
      },
      hasMap: "https://maps.google.com/?q=El+Encanto+de+Benasque",
      geo: {
        "@type": "GeoCoordinates",
        latitude: 42.6043,
        longitude: 0.5244,
      },
      areaServed: {
        "@type": "AdministrativeArea",
        name: "Valle de Benasque",
      },
      amenityFeature: [
        { "@type": "LocationFeatureSpecification", name: "WiFi", value: true },
        {
          "@type": "LocationFeatureSpecification",
          name: "Cocina equipada",
          value: true,
        },
        {
          "@type": "LocationFeatureSpecification",
          name: "Calefacción",
          value: true,
        },
      ],
    },
  ],
};
