const title =
  "Apartamento El Encanto de Benasque | Alojamiento turístico renovado a 5 min de Cerler";
const description =
  "Apartamento turístico renovado en Benasque, en el corazón del Pirineo Aragonés. 2 habitaciones, garaje, WiFi y vistas a Cerler. A 5 minutos de la estación de esquí. Reserva directa al mejor precio.";
const keywords = [
  "apartamento benasque",
  "apartamento en benasque",
  "apartamento renovado benasque",
  "alojamiento benasque",
  "alojamiento económico benasque",
  "alojamiento cerler",
  "apartamento pirineo",
  "apartamento cerler",
  "apartamento en cerler",
  "alquiler apartamento benasque",
  "alojamiento turístico benasque",
  "apartamento pirineo aragonés",
  "alojamiento cerca de cerler",
  "apartamento vacacional benasque",
  "alojamiento valle de benasque",
  "apartamentos turísticos benasque",
  "alquiler vacacional cerler",
  "donde alojarse en benasque",
  "apartamento esquí cerler",
  "apartamento reformado benasque",
  "apartamento benasque cerca cerler",
];

const images = [
  {
    url: "https://elencantodebenasque.com/media/imagen-portada.webp",
    width: 1200,
    height: 630,
    alt: "El Encanto de Benasque - Apartamento renovado con vistas a la montaña",
    type: "image/webp",
  },
  {
    url: "https://elencantodebenasque.com/media/salon.webp",
    width: 1200,
    height: 630,
    alt: "Salón renovado con vistas al Pirineo",
    type: "image/webp",
  },
];

export default {
  title,
  description,
  canonical: "https://elencantodebenasque.com",
  languageAlternates: [
    {
      hrefLang: "es",
      href: "https://elencantodebenasque.com",
    },
    {
      hrefLang: "x-default",
      href: "https://elencantodebenasque.com",
    },
  ],
  openGraph: {
    type: "website",
    locale: "es_ES",
    url: "https://elencantodebenasque.com",
    title,
    description,
    images,
    site_name: "El Encanto de Benasque",
    priceRange: "80€ - 200€",
  },
  twitter: {
    handle: "@encantobenasque",
    site: "@encantobenasque",
    cardType: "summary_large_image",
  },
  additionalMetaTags: [
    {
      name: "keywords",
      content: keywords.join(", "),
    },
  ],
  additionalLinkTags: [
    {
      rel: "icon",
      href: "/favicon.ico",
    },
    {
      rel: "apple-touch-icon",
      href: "/apple-touch-icon.png",
      sizes: "180x180",
    },
    {
      rel: "manifest",
      href: "/site.webmanifest",
    },
  ],
};
